jQuery( function($) {

    // open Theme Reset Modal
    $('.wppb-color-switcher-section button.reset').click(function (e) {
        //let themeID = e.target.id.replace('reset-', '');
        displayResetDialog();
    });

    // close Theme Reset Modal
    $('.wppb-ul-color-switcher-reset-modal button.cancel-reset').click(function (e) {
        //let modalID = '#' + e.target.value;
        closeResetModal();
    });

    //checking all the options when "All" is checked
    $('#wppb-settings-all-colors').on('change', function() {
        const isChecked = $(this).is(':checked');
        $('#color-options input[type="checkbox"]').not(this).prop('checked', isChecked);
    });

    // Uncheck "All" if any other checkbox is unchecked
    $('#color-options input[type="checkbox"]').not('#wppb-settings-all-colors').on('change', function() {
        if (!$(this).is(':checked')) {
            $('#wppb-settings-all-colors').prop('checked', false);
        }
    });
});

/**
 * Display Color Switcher Reset Modal
 */
function displayResetDialog() {
    jQuery('#modal-reset').dialog({
        resizable: false,
        width: 550,
        height: 400,
        modal: true,
        closeOnEscape: true
    });
    return false;
}

/**
 * Close Color Switcher Reset Modal with "close" button
 */
function closeResetModal() {
    jQuery('#modal-reset input[type=checkbox]').prop( 'checked', false );
    jQuery('#modal-reset input[type=checkbox]').removeAttr('disabled');
    jQuery('#modal-reset input[type=checkbox]').parent().css('pointer-events', 'auto');
    jQuery('#modal-reset').dialog('close');
}